from continual_rl.policies.impala.impala_policy_config import ImpalaPolicyConfig
from continual_rl.utils import utils


class ARCPolicyConfig(ImpalaPolicyConfig):
    def __init__(self):
        super().__init__()
        self.embedding_size = 256  # 自监督学习的行为表征长度
        self.sl_buffer_items = 1e4  # 自监督学习的buffer大小
        self.sl_update_steps = 1
        self.sl_learning_rate = 1e-3  # 自监督学习的学习率
        self.sl_batch_size = 256  # 自监督学习的batch size
        self.sl_learning_epoch = 10  # 每次自监督学习的epoch数
        self.contrastive_alpha = 0  # 对比损失的权重，为0时不使用对比损失
        self.explore_unroll_length = 20  # 探索时的展开长度
        self.lambda_ewc = 1e4  # ewc正则化的权重
        self.encoder_lambda_ewc = 0  # 编码器ewc正则化的权重
        self.representation_visualize = False  # 是否可视化行为表征
        self.rank_weight = 0  # 1e3  # rank损失的权重
